# Copyright © 2023 Giovanni Squillero <giovanni.squillero@polito.it>
# https://github.com/squillero/computer-sciences
# Free under certain conditions — see the license for details.

COMMON_WORDS = [
    "the",
    "of",
    "to",
    "and",
    "a",
    "in",
    "is",
    "it",
    "you",
    "that",
    "he",
    "was",
    "for",
    "on",
    "are",
    "with",
    "as",
    "I",
    "his",
    "they",
    "be",
    "at",
    "one",
    "have",
    "this",
    "from",
    "or",
    "had",
    "by",
    "hot",
    "but",
    "some",
    "what",
    "there",
    "we",
    "can",
    "out",
    "other",
    "were",
    "all",
    "your",
    "when",
    "up",
    "use",
    "word",
    "how",
    "said",
    "an",
    "each",
    "she",
    "which",
    "do",
    "their",
    "time",
    "if",
    "will",
    "way",
    "about",
    "many",
    "then",
    "them",
    "would",
    "write",
    "like",
    "so",
    "these",
    "her",
    "long",
    "make",
    "thing",
    "see",
    "him",
    "two",
    "has",
    "look",
    "more",
    "day",
    "could",
    "go",
    "come",
    "did",
    "my",
    "sound",
    "no",
    "most",
    "number",
    "who",
    "over",
    "know",
    "water",
    "than",
    "call",
    "first",
    "people",
    "may",
    "down",
    "side",
    "been",
    "now",
    "find",
    "any",
    "new",
    "work",
    "part",
    "take",
    "get",
    "place",
    "made",
    "live",
    "where",
    "after",
    "back",
    "little",
    "only",
    "round",
    "man",
    "year",
    "came",
    "show",
    "every",
    "good",
    "me",
    "give",
    "our",
    "under",
    "name",
    "very",
    "through",
    "just",
    "form",
    "much",
    "great",
    "think",
    "say",
    "help",
    "low",
    "line",
    "before",
    "turn",
    "cause",
    "same",
    "mean",
    "differ",
    "move",
    "right",
    "boy",
    "old",
    "too",
    "does",
    "tell",
    "sentence",
    "set",
    "three",
    "want",
    "air",
    "well",
    "also",
    "play",
    "small",
    "end",
    "put",
    "home",
    "read",
    "hand",
    "port",
    "large",
    "spell",
    "add",
    "even",
    "land",
    "here",
    "must",
    "big",
    "high",
    "such",
    "follow",
    "act",
    "why",
    "ask",
    "men",
    "change",
    "went",
    "light",
    "kind",
    "off",
    "need",
    "house",
    "picture",
    "try",
    "us",
    "again",
    "animal",
    "point",
    "mother",
    "world",
    "near",
    "build",
    "self",
    "earth",
    "father",
    "head",
    "stand",
    "own",
    "page",
    "should",
    "country",
    "found",
    "answer",
    "school",
    "grow",
    "study",
    "still",
    "learn",
    "plant",
    "cover",
    "food",
    "sun",
    "four",
    "thought",
    "let",
    "keep",
    "eye",
    "never",
    "last",
    "door",
    "between",
    "city",
    "tree",
    "cross",
    "since",
    "hard",
    "start",
    "might",
    "story",
    "saw",
    "far",
    "sea",
    "draw",
    "left",
    "late",
    "run",
    "don’t",
    "while",
    "press",
    "close",
    "night",
    "real",
    "life",
    "few",
    "stop",
    "open",
    "seem",
    "together",
    "next",
    "white",
    "children",
    "begin",
    "got",
    "walk",
    "example",
    "ease",
    "paper",
    "often",
    "always",
    "music",
    "those",
    "both",
    "mark",
    "book",
    "letter",
    "until",
    "mile",
    "river",
    "car",
    "feet",
    "care",
    "second",
    "group",
    "carry",
    "took",
    "rain",
    "eat",
    "room",
    "friend",
    "began",
    "idea",
    "fish",
    "mountain",
    "north",
    "once",
    "base",
    "hear",
    "horse",
    "cut",
    "sure",
    "watch",
    "color",
    "face",
    "wood",
    "main",
    "enough",
    "plain",
    "girl",
    "usual",
    "young",
    "ready",
    "above",
    "ever",
    "red",
    "list",
    "though",
    "feel",
    "talk",
    "bird",
    "soon",
    "body",
    "dog",
    "family",
    "direct",
    "pose",
    "leave",
    "song",
    "measure",
    "state",
    "product",
    "black",
    "short",
    "numeral",
    "class",
    "wind",
    "question",
    "happen",
    "complete",
    "ship",
    "area",
    "half",
    "rock",
    "order",
    "fire",
    "south",
    "problem",
    "piece",
    "told",
    "knew",
    "pass",
    "farm",
    "top",
    "whole",
    "king",
    "size",
    "heard",
    "best",
    "hour",
    "better",
    "true",
    "during",
    "hundred",
    "am",
    "remember",
    "step",
    "early",
    "hold",
    "west",
    "ground",
    "interest",
    "reach",
    "fast",
    "five",
    "sing",
    "listen",
    "six",
    "table",
    "travel",
    "less",
    "morning",
    "ten",
    "simple",
    "several",
    "vowel",
    "toward",
    "war",
    "lay",
    "against",
    "pattern",
    "slow",
    "center",
    "love",
    "person",
    "money",
    "serve",
    "appear",
    "road",
    "map",
    "science",
    "rule",
    "govern",
    "pull",
    "cold",
    "notice",
    "voice",
    "fall",
    "power",
    "town",
    "fine",
    "certain",
    "fly",
    "unit",
    "lead",
    "cry",
    "dark",
    "machine",
    "note",
    "wait",
    "plan",
    "figure",
    "star",
    "box",
    "noun",
    "field",
    "rest",
    "correct",
    "able",
    "pound",
    "done",
    "beauty",
    "drive",
    "stood",
    "contain",
    "front",
    "teach",
    "week",
    "final",
    "gave",
    "green",
    "oh",
    "quick",
    "develop",
    "sleep",
    "warm",
    "free",
    "minute",
    "strong",
    "special",
    "mind",
    "behind",
    "clear",
    "tail",
    "produce",
    "fact",
    "street",
    "inch",
    "lot",
    "nothing",
    "course",
    "stay",
    "wheel",
    "full",
    "force",
    "blue",
    "object",
    "decide",
    "surface",
    "deep",
    "moon",
    "island",
    "foot",
    "yet",
    "busy",
    "test",
    "record",
    "boat",
    "common",
    "gold",
    "possible",
    "plane",
    "age",
    "dry",
    "wonder",
    "laugh",
    "thousand",
    "ago",
    "ran",
    "check",
    "game",
    "shape",
    "yes",
    "hot",
    "miss",
    "brought",
    "heat",
    "snow",
    "bed",
    "bring",
    "sit",
    "perhaps",
    "fill",
    "east",
    "weight",
    "language",
    "among",
]


def distance_simple(word1, word2):
    assert len(word1) == len(word2), "D'ho"
    dist = 0
    for index in range(len(word1)):
        if word1[index].upper() != word2[index].upper():
            dist += 1
    return dist


def distance(word1, word2):
    # Fore real programmers
    assert len(word1) == len(word2)
    dist = 0
    for c1, c2 in zip(word1, word2):
        if c1.casefold() != c2.casefold():
            dist += 1
    return dist


def distance_dictionary(word):
    dist_dict = dict()
    for good in COMMON_WORDS:
        if len(word) == len(good):
            d = distance(good, word)
            if d < 2:
                dist_dict[good] = d
    return dist_dict


def find_min(ddict):
    min_distance = 99999999
    words = list()
    for key, value in ddict.items():
        if value < min_distance:
            words = [key]
            min_distance = value
        elif value == min_distance:
            words.append(key)
    return words


word = input()
while word:
    print(f"Working on '{word}'")
    tmp = distance_dictionary(word)
    print(find_min(tmp))
    word = input()
